#ifdef GL_ES
precision mediump float;
#endif

// output from the vertex shader (fragment color)
varying vec4 v_fragmentColor;
varying vec2 v_texCoord;


// main shader function
void main() {
	vec2 coord = v_texCoord.xy;

	float f = (coord.x - coord.y) / 16.0;
	// stripe color: < 0.5 -> dark, > 0.5 -> bright
	float stripe = fract(f);

	vec3 color = v_fragmentColor.rgb;
	// stripe smoothing
	color /= 3.0 * (
					(1.0 - smoothstep(-0.1, 0.1, stripe)) // smooth low end, bright to dark
					+ smoothstep(0.4, 0.6, stripe) // smooth mid, dark to bright
					- smoothstep(0.9, 1.1, stripe) // smooth high end, bright to dark
					)
			+ 1.0;

	gl_FragColor = vec4(color, v_fragmentColor.a);
}
